#!/bin/bash
exp_id=$1
num_shadow=$2

DATA_PATH="datasets"
SAVE_PATH="exps/DSA_cinic_init_lr_img_0.2"
LIRA_PATH="$SAVE_PATH/lira"

python src/dd/main_DC.py \
    --method DSA \
    --dataset CIFAR10 \
    --model ConvNet \
    --ipc 1000 \
    --dsa_strategy color_crop_cutout_flip_scale_rotate \
    --init cinic10 \
    --cinic10 datasets/cinic10 \
    --lr_img 0.2 \
    --num_eval 1 \
    --eval_freq 100 \
    --Iteration 800 \
    --exp_id $exp_id \
    --num_shadow $num_shadow \
    --num_canaries 500 \
    --data_path $DATA_PATH \
    --lira_path $LIRA_PATH \
    --save_path $SAVE_PATH > logs/dm/DSA_cinic_exp_$exp_id.log 2>&1
